'use client';

import { UtensilsCrossed } from 'lucide-react';
import Image from 'next/image';
import { useRestaurantInfo } from '@/hooks/use-restaurant-info';
import { Skeleton } from '@/components/ui/skeleton';

export function MenuHeader() {
  const { restaurantInfo, isLoaded } = useRestaurantInfo();

  return (
    <header className="bg-card/80 backdrop-blur-sm sticky top-0 z-40 w-full border-b">
      <div className="max-w-7xl mx-auto flex h-16 items-center justify-between px-4">
        <div className="flex items-center gap-2">
          {!isLoaded ? (
            <>
              <Skeleton className="h-10 w-10 rounded-full" />
              <Skeleton className="h-6 w-32" />
            </>
          ) : restaurantInfo.logoUrl ? (
             <Image
                src={restaurantInfo.logoUrl}
                alt={restaurantInfo.name}
                width={40}
                height={40}
                className="rounded-full object-cover"
              />
          ) : (
            <UtensilsCrossed className="h-8 w-8 text-primary" />
          )}
          {isLoaded && (
            <span className="text-xl font-bold font-headline tracking-tight">
              {restaurantInfo.name}
            </span>
          )}
        </div>
      </div>
    </header>
  );
}
